#include "include/json2.js"
#include "include/MeryInfo.js"

// IO
//
// 【概要】
//   IO 系処理のライブラリ
//
// 【使用例】
// // マクロフォルダ直下の .js ファイル数を得る
// var MacroFolder = new IO.Folder(MeryInfo.GetMacroFolderPath());
// var MacroFiles = MacroFolder.GetFiles("*.js");
// // var MacroFiles = MacroFolder.GetFiles(/.js$/);
// // var MacroFiles = MacroFolder.GetFiles(function(f){return f.GetName().slice(-3)==".js"});
// Alert(MacroFiles.length);
// 
// 【使用例】
// Alert(IO.LoadFromFile(Document.FullName));
//
// 【使用例】
// // 実行回数を記録する
// var data = {count:1};
// data = IO.Deserialize(data);
// Alert(String.Format("このマクロは %d 回実行されました．", data.count));
// data.count++;
// IO.Serialize(data);

var IO;
if (IO == null) {
	IO = (function() {
		// Private Instance Member Value
		var _fso = new ActiveXObject('Scripting.FileSystemObject');
		var _shell = new ActiveXObject('WScript.Shell');

		var _adTypeBinary = 1;
		var _adTypeText = 2;
		var _adReadAll = -1;
		var _adSaveCreateOverWrite = 2;

		var _included = {};		// include 済みのファイル一覧
		var _nestCount = 0;		// include のネスト数

		// シリアライズのファイルパスを取得
		var _GetSerializePath = function(name) {
			name = (name || IO.Path.GetBase(ScriptName)) + '.json';
			if (MeryInfo.IsPortable()) {
				return IO.Path.Add(MeryInfo.GetMacroFolderPath(), 'MacroSettings', name);
			} else {
				return IO.Path.Add(MeryInfo.GetSettingFolderPath(), 'MacroSettings', name);
			}
		}

		// 特定のオブジェクトが存在するかをチェック
		var _NeedInclude = function(cls, name) {
			name = name || cls;
			try {
				eval(cls);
			} catch(e) {
				Alert('"' + name + '.js" の include が不足しています');
				Quit();
			}
		}
		
		// 内部の文字コード番号を Adodb 向けの文字に変換
		var _ConvertCharset = function(charset) {
			if (typeof charset === 'number') {
				switch (charset) {
				case meEncodingUTF16LE:
				case meEncodingUTF16BE:					charset = 'unicode';		break;
				case meEncodingUTF8WithSignature:		
				case meEncodingUTF8WithoutSignature:	charset = 'utf-8';			break;
				case meEncodingUTF7:					charset = 'utf-7';			break;
				case meEncodingEUC:						charset = 'euc-jp';			break;
				case meEncodingJIS:						charset = 'iso-2022-jp';	break;
				case meEncodingShiftJIS:				charset = 'shift-jis';		break;
				}
			}
			return charset;
		}
		
		var _GetHasBOM = function(charset, hasBOM) {
			if (typeof charset === 'number') {
				switch (charset) {
				case meEncodingUTF8WithSignature:
					hasBOM = true;
				}
			}
			return hasBOM;
		}

		return {
			// パス操作
			Path: {
				// パス連結
				Add: function(a, b) {
					var path = a;
					for (var i=1; i<arguments.length; i++) {
						path = _fso.BuildPath(path, arguments[i]);
					}
					return path;
				},
				// 親フォルダ名取得
				GetParent: function(p) {
					return _fso.GetParentFolderName(p);
				},
				// ファイル存在確認
				IsExist: function(p) {
					return _fso.FileExists(p) || _fso.FolderExists(p);
				},
				// 拡張子取得
				GetExtension: function(p) {
					return _fso.GetExtensionName(p);
				},
				// ファイル名取得
				GetFileName: function(p) {
					return _fso.GetFileName(p);
				},
				// ファイル名（拡張子除き）を取得
				GetBase: function(p) {
					return _fso.GetBaseName(p);
				},
				// ドライブパス取得
				GetDrive: function(p) {
					return _fso.GetDriveName(p);
				},
				// 絶対パス取得
				GetAbsolute: function(p) {
					return _fso.GetAbsolutePathName(p);
				},
				// フォルダか判定
				IsFolder: function(p) {
					return _fso.FolderExists(p);
				},
				// ファイルか判定
				IsFile: function(p) {
					return _fso.FileExists(p);
				},
				SetCurrent: function(p) {
					_shell.CurrentDirectory = p;
				},
				GetCurrent: function() {
					return _shell.CurrentDirectory;
				}
			},

			// フォルダ生成
			CreateFolder: function(path) {
				if (!this.Path.IsExist(path)) {
					this.CreateFolder(this.Path.GetParent(path));
					_fso.CreateFolder(path);
				}
			},
			
			// ファイル読み込み
			LoadFromFile: function(path, charset) {
				if (!_fso.FileExists(path)) {
					return null;
				}
				charset = _ConvertCharset(charset);
				var adodb = new ActiveXObject('ADODB.Stream');
				charset = charset || '_autodetect_all';
				// BOM 判定
				var skip = 0;
				adodb.Type = _adTypeText;
				if (charset.toLowerCase() == 'utf-8' || charset == '_autodetect_all') {
					try {
						adodb.Charset = 'iso-8859-1';
						adodb.Open();
						adodb.LoadFromFile(path);
						if (adodb.Size >= 3) {
							var binaries = adodb.ReadText(3);
							if (binaries.charCodeAt(0) == 0xEF && binaries.charCodeAt(1) == 0xBB && binaries.charCodeAt(2) == 0xBF) {
								charset == 'utf-8'
								skip = 3;
							}
						}
					} finally {
						adodb.Close();
					}
				}
				try {
					adodb.Charset = charset;
					adodb.Open();
					adodb.LoadFromFile(path);
					adodb.Position = skip;
					return adodb.ReadText(_adReadAll).replace(/\r\n?/g, '\n');
				} finally {
					adodb.Close();
				}
			},

			// ファイル書込
			SaveToFile: function(path, text, charset, hasBOM, newline) {
				hasBOM = _GetHasBOM(charset, hasBOM);
				charset = _ConvertCharset(charset) || 'utf-8';
				var adodb = new ActiveXObject('ADODB.Stream');
				adodb.Charset = charset;
				adodb.Type = _adTypeText;
				try {
					adodb.Open();
					if (newline || newline === undefined) {
						text = text.replace(/\r?\n/g, newline || '\r\n');
					}
					adodb.WriteText(text);

					// BOM 削除処理
					if (!hasBOM && charset.toLowerCase() === 'utf-8') {
						adodb.Position = 0;
						adodb.Type = _adTypeBinary;
						adodb.Position = 3;		// BOM の分だけスキップ
						var binary = adodb.Read();
						var isEmpty = adodb.Position == 3;
						adodb.Close();

						// 新規ストリームに BOM を除いた文字列を書き込む
						adodb.Open();
						if (!isEmpty) {
							adodb.Write(binary);
						}
					}
					adodb.SaveToFile(path, _adSaveCreateOverWrite);
				} finally {
					adodb.Close();
				}
			},

			// バイナリファイルを作成
			SaveBinaryToFile: function(path, binaries) {
				var adodb = new ActiveXObject('ADODB.Stream');
				adodb.Type = _adTypeBinary;
				try {
					adodb.Open();
					adodb.Write(binaries);
					adodb.SaveToFile(path, _adSaveCreateOverWrite);
				} finally {
					adodb.Close();
				}
			},

			// ドキュメントをファイルに書込
			SaveDocumentToFile: function(path, doc, newline){
				newline = newline || '\r\n';

				var charset = 'utf-8';
				switch (doc.Encoding) {
					case meEncodingUTF16LE:
					case meEncodingUTF16BE:					charset = 'unicode';		break;
					case meEncodingUTF8WithSignature:		
					case meEncodingUTF8WithoutSignature:	charset = 'utf-8';			break;
					case meEncodingUTF7:					charset = 'utf-7';			break;
					case meEncodingEUC:						charset = 'euc-jp';			break;
					case meEncodingJIS:						charset = 'iso-2022-jp';	break;
					case meEncodingShiftJIS:				charset = 'shift-jis';		break;
				}

				this.SaveToFile(path, text, charset, doc.Encoding == meEncodingUTF8WithSignature, newline);
			},

			// オブジェクトをファイルに保存
			Serialize: function(obj, name) {
				var path = _GetSerializePath(name);
				this.CreateFolder(this.Path.GetParent(path));
				this.SaveToFile(path, JSON.stringify(obj), "utf-8");
			},

			// オブジェクトをファイルから読込
			Deserialize: function(def, name) {
				var path = _GetSerializePath(name);
				if (this.Path.IsExist(path)) {
					var obj = JSON.parse(this.LoadFromFile(path, "utf-8"));
					if (def) {
						// mixin
						for (var v in def) if (def.hasOwnProperty(v) ) {
							if (!(v in obj)) {
								obj[v] = def[v];
							}
						}
					}
					return obj;
				}
				return def;
			},

			// 疑似 include 処理
			Include: function(path, charset) {
				var directory = _shell.CurrentDirectory;
				if (_nestCount == 0) {
					_shell.CurrentDirectory = Editor.FullName.match(/^.*\\/)[0] + 'Macros';
				}
				try {
					// 1. Macros からの相対パス
					// 2. 読込元ファイルからの相対パス
					var absPath = this.Path.Add(MeryInfo.GetMacroFolderPath(), path);
					if (this.Path.IsFile(absPath)) {
						var file = _fso.GetFile(absPath);
					} else {
						if (this.Path.IsFile(path)) {
							var file = _fso.GetFile(path);
						} else {
							Alert('include するファイル "' + path + '" が見つかりません．');
							Quit();
						}
					}
					_shell.CurrentDirectory = _fso.GetParentFolderName(file.Path);

					// 既に読込済みの場合は空文字を返す
					if (file.Path in _included) {
						return '';
					}
					_included[file.Path] = true;

					//var filename = file.Path.match(/[^\\]+$/)[0];
					var text = this.LoadFromFile(file.Path);
					if (text == null) {
						Alert(path + ' が見つかりません．');
						return null;
					}

					// プリプロセッサを処理
					var lines = text.split('\n');
					var head = '';
					for (var i=0; i<lines.length; i++) {
						if (/^\s*$/.test(lines[i])) {
							continue;
						} else if (/^\s*#/.test(lines[i])) {
							// #include 対応
							if (/^[ \t]*#include[ \t]+["|'](.+)["|']/.test(lines[i])) {
								var target = RegExp.$1;
								_nestCount++;
								head += this.Include(target, charset);
								_nestCount--;
								if (head == null) {
									return null;
								}
							}
							continue;
						} else if (/^\s*\/\//.test(lines[i])) {
							// コメント行読み飛ばし
							continue;
						} else {
							break;
						}
					}
					text = head + (head ? "\n" : "") + lines.slice(i).join('\n');
					//return "try{\n" + text + "\n}catch(e){Alert('IO.Include 中に \""+filename+"\" でエラーが発生しました。\\n\\nエラー内容：\\n'+e.message);Quit();}\n";
					return text;
				} finally {
					if (file != null && _shell.CurrentDirectory == _fso.GetParentFolderName(file.Path)) {
						_shell.CurrentDirectory = directory;
					}
				}
			},
			
			// フォルダオブジェクト
			Folder: (function() {
				function Folder(path) {
					// Private Instance Member Value
					var _folder = null;		// Folder オブジェクト

					// Private Instance Member Function
					var _GetSelector = function(pattern) {
						var selector = function() {return true};
						if (pattern) {
							if (typeof pattern == 'string') {
								pattern = new RegExp(pattern.replace(/[\\\^\$\*\+\?\.\(\)\|\{\}\[\]]/g, function(a){
									switch (a) {
										case '*': return '.*';
										case '?': return '.';
									}
									return '\\' + a;
								}), 'i');
							}
							if (pattern instanceof RegExp) {
								selector = function(f) {return pattern.test(f.GetName())};
							} else if (typeof pattern == 'function') {
								selector = pattern;
							}
						}
						return selector;
					};

					// Public Instance Member Value

					// Public Instance Member Function
					// ディレクトリか判定
					this.IsDirectory = function() {
						return true;
					}

					// オブジェクトを取得
					this.GetObject = function() {
						return _folder;
					}

					// 属性を取得
					this.GetAttributes = function() {
						return _folder.Attributes;
					}

					// 属性を設定
					this.SetAttributes = function(attributes) {
						_folder.Attributes = attributes;
					}

					// 作成日付を取得
					this.GetDateCreated = function() {
						return _folder.DateCreated;
					}

					// 最終アクセス日を取得
					this.GetDateLastAccessed = function() {
						return _folder.DateLastAccessed;
					}

					// 更新日を取得
					this.GetDateLastModified = function() {
						return _folder.DateLastModified;
					}

					// ディレクトリ名を取得
					this.GetName = function() {
						return String(_folder.Name);
					}

					// ディレクトリ名を設定
					this.SetName = function(name) {
						_folder.Name = name;
					}

					// 親ディレクトリパスを取得
					this.GetParentFolder = function() {
						return _folder.ParentFolder;
					}

					// 自身のパスを取得
					this.GetPath = function() {
						return _folder.Path;
					}

					// フォルダサイズを取得
					// ただし誤実行防止のため isGetRecursive に true を渡した場合のみ動作
					this.GetSize = function(isGetRecursive) {
						if (isGetRecursive) {
							return _folder.Size;
						}
						return 0;
					}

					// ディレクトリの種類を取得
					this.GetType = function() {
						return _folder.Type;
					}

					// ディレクトリ内のファイル一覧を取得
					// pattern に渡す定義は次の通り
					// 文字列：*.txt
					// 正規表現：/.*\.txt$/
					// 関数：function(file){ if(file.GetExtension.equalsIgnoreCase(".txt")){ return true; } }
					this.GetFiles = function(pattern) {
						var selector = _GetSelector(pattern);
						var e = new Enumerator(_folder.Files);
						var a = [];
						for (; !e.atEnd(); e.moveNext()) {
							var f = new IO.File(e.item());
							if (selector(f)) {
								a.push(f);
							}
						}
						return a;
					}

					// ディレクトリ内のフォルダ一覧を取得
					this.GetFolders = function(pattern) {
						var selector = _GetSelector(pattern);
						var e = new Enumerator(_folder.SubFolders);
						var a = [];
						for (; !e.atEnd(); e.moveNext()) {
							var f = new IO.Folder(e.item());
							if (selector(f)) {
								a.push(f);
							}
						}
						return a;
					}

					// ディレクトリをコピー
					this.Copy = function(path, isOverwrite) {
						_folder.Copy(path, isOverwrite);
					}

					// ディレクトリを削除
					this.Delete = function(isForce) {
						_folder.Delete(isForce);
					}

					// ディレクトリを移動
					this.Move = function(path) {
						_folder.Move(path);
					}

					// Initialize
					if (typeof path == 'string') {
						_folder = _fso.GetFolder(path);
					} else if (path != null) {
						_folder = path;
					} else {
						Alert('IO.Folder の初期化に失敗');
					}
				}
				return Folder;
			})(),

			// ファイルオブジェクト
			File: (function() {
				function File(path) {
					// Private Instance Member Value
					var _file = null;		// File オブジェクト

					// Private Instance Member Function

					// Public Instance Member Value

					// Public Instance Member Function
					
					// ディレクトリかを取得
					this.IsDirectory = function() {
						return false;
					}

					// File オブジェクトを取得
					this.GetObject = function() {
						return _file;
					}

					// ファイル属性を取得
					this.GetAttributes = function() {
						return _file.Attributes;
					}

					// ファイル属性を設定
					this.SetAttributes = function(attributes) {
						_file.Attributes = attributes;
					}

					// 作成日を取得
					this.GetDateCreated = function() {
						return _file.DateCreated;
					}

					// 最終アクセス日を取得
					this.GetDateLastAccessed = function() {
						return _file.DateLastAccessed;
					}

					// 更新日を取得
					this.GetDateLastModified = function() {
						return _file.DateLastModified;
					}

					// ファイル名を取得
					this.GetName = function() {
						return _file.Name;
					}

					// ファイル名を設定
					this.SetName = function(name) {
						_file.Name = name;
					}

					// 親ディレクトリ名を取得
					this.GetParentFolder = function() {
						return _file.ParentFolder;
					}

					// パスを取得
					this.GetPath = function() {
						return _file.Path;
					}

					// ファイルサイズを取得
					this.GetSize = function() {
						return _file.Size;
					}

					// ファイル種類を取得
					this.GetType = function() {
						return _file.Type;
					}

					// ファイルをコピー
					this.Copy = function(path, isOverwrite) {
						_file.Copy(path, isOverwrite);
					}

					// ファイルを削除
					this.Delete = function(isForce) {
						_file.Delete(isForce);
					}

					// ファイルを移動
					this.Move = function(path) {
						_file.Move(path);
					}
					
					// 実行
					this.Exec = function(arg, style, wait) {
						arg = arg || '';
						style = style || 0;
						wait = wait==null ? true : false;
						return _shell.Run('"' + _file.Path + '" ' + arg, style, wait);
					}
					
					// テキストとしてロード
					this.LoadText = function(charset) {
						return IO.LoadFromFile(_file.Path, charset);
					}
					
					// テキストをセーブ
					this.SaveText = function(text, charset, hasBOM, newline) {
						return IO.SaveToFile(_file.Path, text, charset, hasBOM, newline);
					}

					// Initialize
					if (typeof path == 'string') {
						_file = _fso.GetFile(path);
					} else if (path != null) {
						_file = path;
					} else {
						Alert('IO.File の初期化に失敗');
					}
				}
				return File;
			})(),

			// ファイル属性
			Attribute: {
				Normal: 0x00,
				ReadOnly: 0x01,		// Get | Set
				Hidden: 0x02,		// Get | Set
				System: 0x04,		// Get | Set
				Volume: 0x08,		// Get
				Directory: 0x10,	// Get
				Archive: 0x20,		// Get | Set
				Alias: 0x40,		// Get
				Compressed: 0x80	// Get
			}
		};
	})();
}