#include "include/StringEx.js"
#include "include/StateBackup.js"

// MeryInfo
//
// 【概要】
//   Mery に関する情報を取得する
//
// 【使用例】
// Document.Selection.Replace('\t', " ".repeat(MeryInfo.GetTabSpace()), meReplaceAll);

var MeryInfo;
if (MeryInfo == null) {
	MeryInfo = (function() {
		// Private Static Member Value
		var _shell = new ActiveXObject('WScript.Shell');
		var _fso = new ActiveXObject('Scripting.FileSystemObject');

		var _iniPath = null;
		var _isPortable = null;

		var _isWrap = null;			// 折り返しの有効/無効．
		var _wrapLen = null;		// 文字数(折り返し無効時は-1)．
		var _tabSpace = null;		// tab <=> space の変換値．
		var _isTab2Space = null;	// 「タブの代わりに空白を挿入」オプション．
		var _isAutoIndent = null;	// 「自動インデントを有効にする」オプション．
		var _startDate = null;		// Mery 開始時刻

		// Private Static Member Function
		var _Init = function() {
			var doc = Editor.ActiveDocument;
			var sel = doc.Selection;
			var d = 0;	// 変更回数(Undo用)
			var state = new StateBackup();
			doc.Write("\n\n");	d++;
			var ly = sel.GetActivePointY(mePosLogical) - 1;
			var vy = sel.GetActivePointY(mePosView) - 1;
			sel.SetActivePoint(mePosLogical, 1, ly);
			
			// 折り返し判定
			doc.Write(" ".repeat(8000));	d++;
			sel.EndOfLine(mePosLogical);
			_isWrap = sel.GetActivePointY(mePosView) > vy;
			
			// 折り返し位置取得
			if (_isWrap) {
				sel.SetActivePoint(mePosLogical, 1, ly);
				sel.SetAnchorPoint(mePosView, 1, vy+1);
				_wrapLen = sel.Text.length;
			} else {
				_wrapLen = 8000;
			}
			doc.Undo();	d--;

			// タブ幅取得
			doc.Write("\t");	d++;
			sel.EndOfLine(false, mePosLogical);
			sel.SetAnchorPoint(mePosLogical, 1, ly);
			sel.Untabify();		d++;
			_tabSpace = sel.Text.replace("\n", "").length;

			// タブ=>空白挿入，オートインデントの判定
			sel.Indent();		d++;
			_isTab2Space = sel.Text.indexOf("\t") == -1;
			sel.Collapse(meCollapseEnd);
			sel.NewLine(1);		d++;
			sel.SelectLine();
			_isAutoIndent = sel.Text.replace("\n", "").length > 0;

			// 作業データ削除
			for (var i=0; i<d; i++) {
				doc.Undo();
			}
			state.Restore();
		}

		// Public Static Member Function
		return {
			/**
			 * Meryの設定保存フォルダパス文字列を取得．
			 * @returns {String} 設定保存フォルダパス．
			 */
			GetSettingFolderPath: function() {
				return _fso.BuildPath(_shell.SpecialFolders('Appdata'), 'Mery');
			},

			/**
			 * Meryのマクロフォルダパス文字列を取得．
			 * @returns {String} マクロフォルダパス．
			 */
			GetMacroFolderPath: function() {
				return _fso.BuildPath(_fso.GetParentFolderName(Editor.FullName), 'Macros');
			},

			/**
			 * Mery.iniのフォルダパスを取得．<br>
			 * Meryと同様，1.実行ファイル，2.ユーザフォルダの順に探す．
			 * @returns {String} Mery.iniのフォルダパス
			 */
			GetIniPath: function() {
				if (_iniPath == null) {
					if (this.IsPortable()) {
						_iniPath = _fso.BuildPath(_fso.GetParentFolderName(Editor.FullName), 'Mery.ini');
					} else {
						_iniPath = _fso.BuildPath(this.GetSettingFolderPath(), 'Mery.ini');
					}
				}
				return _iniPath;
			},

			/**
			 * Mery がポータブルかを取得．<br>
			 * @returns {Boolean} ポータブルの時 true
			 */
			IsPortable: function() {
				if (_isPortable == null) {
					var s = _fso.BuildPath(_fso.GetParentFolderName(Editor.FullName), 'Mery.ini');
					if (_fso.FileExists(s)) {
						_isPortable = true;
					} else {
						_isPortable = false;
					}
				}
				return _isPortable;
			},

			/**
			 * 折り返しの有効/無効を取得．
			 * @returns {Boolean} 有効のときtrue．
			 */
			IsWrap: function() {
				if (_isWrap == null) {
					_Init();
				}
				return _isWrap;
			},

			/**
			 * 「タブの代わりに空白を挿入」オプションを取得．
			 * @returns {Boolean} オプションが有効か．
			 */
			IsTab2Space: function() {
				if (_isTab2Space == null) {
					_Init();
				}
				return _isTab2Space;
			},

			/**
			 * 「自動インデントを有効にする」オプションを取得．
			 * @returns {Boolean} オプションが有効か．
			 */
			 IsAutoIndent: function() {
				if (_isAutoIndent == null) {
					_Init();
				}
				return _isAutoIndent;
			},

			/**
			 * タブ幅を取得．
			 * @returns {Number} タブ幅．
			 */
			 GetTabSpace: function() {
				if (_tabSpace == null) {
					_Init();
				}
				return _tabSpace;
			},
			
			/**
			 * Mery の開始時刻を取得．
			 * @return {Date} 開始時刻．
			 */
			GetStartDate: function() {
				if (_startDate == null) {
					var oLocator = new ActiveXObject("WBemScripting.SWbemLocator");
					var oService = oLocator.ConnectServer();
					var s = "Select CreationDate From Win32_Process Where ExecutablePath = '" + Editor.FullName.replace(/\\/g, "\\\\") + "' ";
					var result = new Enumerator(oService.ExecQuery(s));
					var out = null;
					if (!result.atEnd()) {
						var t = result.item().CreationDate;
						_startDate = new Date(t.substr(0, 4), t.substr(4, 2) - 1, t.substr(6, 2), t.substr(8, 2), t.substr(10, 2), t.substr(12, 2));
					}
				}
				return _startDate;
			}
		}
	})();
}