var FindReplace;
if (FindReplace == null) {
	FindReplace = (function() {
		// Private Static Member Function
		var _IsRegExp = function(v) {return v instanceof RegExp};
		var _IsString = function(v) {return typeof v == 'string'};
		var _IsFunction = function(v) {return typeof v == 'function'};
		
		function FindReplace(doc) {
			// Private Instance Member Value
			var _d = doc || Editor.ActiveDocument;	// 対象のドキュメント（未指定の場合はアクティブドキュメント）
			var _s = _d.Selection;
			
			// Private Instance Member Function
			

			// Public Instance Member Value
			//this.*** = null;
			
			// Public Instance Member Function
			this.FindAsIndex = function(target, isCaseSensitive) {
				isCaseSensitive = isCaseSensitive == null ? true : isCaseSensitive;
				var t = _d.Text;

				var r = [];
				if (FindReplace._IsString(target)) {
					if (!isCaseSensitive) {
						t = t.toLowerCase();
						target = target.toLowerCase();
					}
					var a = t.split('\n');
					for (var i=0; i<a.length; i++) {
						if (a[i].indexOf(target) >= 0) {
							r.push(i+1);
						}
					}
				} else if (FindReplace._IsRegExp(target)) {
					var a = t.split('\n');
					for (var i=0; i<a.length; i++) {
						if (a[i].search(target) >= 0) {
							r.push(i+1);
						}
					}
				}
				return r;
			};

			this.FindAsIndexUseMery = function() {
				// ハイライトがない場合は未検索として処理しない
				if (!_d.HighlightFind) {
					return null;
				}

				var state = new StateBackup(doc);
				_s.StartOfDocument();
				var pos = -1;
				var lines = _d.GetLines(0);
				var r = [];
				while (true) {
					_s.FindRepeat(meFindNext);
					if (!_s.Text) {
						break;
					}

					// 巡回チェック
					if (_s.GetActivePos() < pos) {
						break;
					}
					pos = _s.GetActivePos();

					r.push(_s.GetTopPointY(mePosLogical));
					if (r[r.length-1] == lines) {
						break;
					}
					_s.SetActivePoint(mePosLogical, 1, r[r.length-1] + 1);
				}
				state.Restore();
				return r;
			}

			this.FindAsArray = function(target, isCaseSensitive) {
				isCaseSensitive = isCaseSensitive == null ? true : isCaseSensitive;
				var t = _d.Text;

				var r = [];
				if (FindReplace._IsString(target)) {
					var _target = target;
					var _t = t;
					if (!isCaseSensitive) {
						t = t.toLowerCase();
						target = target.toLowerCase();
					}
					var b = 0;
					while (true) {
						var e = t.indexOf(target, b);
						if (e >= 0) {
							r.push({index:e, length:target.length, text:_t.substr(e, target.length)});
						} else {
							break;
						}
						b = e + _target.length;
					}
				} else if (FindReplace._IsRegExp(target)) {
					while (true) {
						var e = t.search(target);
						if (e >= 0) {
							r.push({index:e, length:RegExp.lastMatch.length, text:RegExp.lastMatch});
						} else {
							break;
						}
						t = RegExp.rightContext;
					}
				}
				return r;
			};

			this.ReplaceByArray = function(array) {
				array.sort(function(a, b){ return b.index - a.index});
				var t = _d.Text;
				var r = [];
				var e = t.length;
				for (var i=0; i<array.length; i++) {
					r.push(t.substring(array[i].index + array[i].length, e));
					r.push(array[i].text);
					e = array[i].index;
				}
				r.push(t.substring(0, e));
				_d.Text = r.reverse().joint('');
			};

			// Initialize
		}

		return FindReplace;
	})();
}