// MathEx
//
// 【概要】
//   Math オブジェクトを拡張する
//
// 【使用例】
// Alert(Math.round(1.2345, -3));

var __MATHEX_JS__
(function(){
	if (__MATHEX_JS__) {
		return;
	}
	__MATHEX_JS__ = true;

	// 小数点以下の有効桁数（補正に使用）
	var precision = -12;

	// 指定桁で繰り上げる
	if (Math._ceil == null) {
		Math._ceil = Math.ceil;
		Math.ceil = function(n, d){
			return Math._ceil(n / Math.pow(10, d || 0)) * Math.pow(10, d || 0);
		};
	}

	// 指定桁で繰り下げる
	if (Math._floor == null) {
		Math._floor = Math.floor;
		Math.floor = function(n, d){
			return Math._floor(n / Math.pow(10, d || 0)) * Math.pow(10, d || 0);
		};
	}

	// 指定桁で四捨五入
	if (Math._round == null) {
		Math._round = Math.round;
		Math.round = function(n, d){
			return Math._round(n / Math.pow(10, d || 0)) * Math.pow(10, d || 0);
		};
	}

	// sin を度数で計算
	Math.sinD = function(d) {
		return Math.round(Math.sin(d/180*Math.PI), precision);
	}
	// cos を度数で計算
	Math.cosD = function(d) {
		return Math.round(Math.cos(d/180*Math.PI), precision);
	}
	// tan を度数で計算
	Math.tanD = function(d) {
		return Math.round(Math.tan(d/180*Math.PI), precision);
	}
	// asin を度数で取得
	Math.asinD = function(a) {
		return Math.round(Math.asin(a)/180*Math.PI, precision);
	}
	// acos を度数で取得
	Math.acosD = function(a) {
		return Math.round(Math.acos(a)/180*Math.PI, precision);
	}
	// atan を度数で取得
	Math.atanD = function(a) {
		return Math.round(Math.atan(a)/180*Math.PI, precision);
	}
	// atan2 を度数で取得
	Math.atan2D = function(a, b) {
		return Math.round(Math.atan(a, b)/180*Math.PI, precision);
	}

	// [0, a] または [a, b] の整数乱数を生成
	if (Math._random == null) {
		Math._random = Math.random;
		Math.random = function(a, b) {
			switch (arguments.length) {
			// [0, a) までの整数を返す
			case 1:
				return Math._floor(Math._random() * a);
			// [a, b] までの整数を返す
			case 2:
				return Math._floor(Math._random() * (Math.abs(b - a)+1)) + Math.min(a, b);
			}
			return Math._random();
		}
	}
})();