#include "include/StringEx.js"
#include "include/IO.js"

// MeryInfo
//
// 【概要】
//   Mery に関する情報を取得する
//
// 【使用例】
// Document.Selection.Replace('\t', " ".repeat(MeryInfo.GetTabSpace()), meReplaceAll);

var MeryInfo;
if (MeryInfo == null) {
	MeryInfo = (function() {
		// Private Static Member Value
		var _shell = new ActiveXObject('WScript.Shell');

		var _iniPath = null;
		var _isPortable = null;

		var _info = null;

		var _startDate = null;		// Mery 開始時刻

		// Private Static Member Function
		var _Init = function() {
			_info = {
				iniUpdateTime : 0,
				// 折り返しの有効/無効
				isWrap : false,
				// 文字数(折り返し無効時は-1)
				wrapLen : -1,
				// tab <=> space の変換値
				tabSpace : 4,
				// 「タブの代わりに空白を挿入」オプション
				isTab2Space : false,
				// 「自動インデントを有効にする」オプション
				isAutoIndent : false
			};
			_info = IO.Deserialize(_info, '__MeryInfoCache');

			// 更新されていない場合はキャッシュを使用
			var ini = new IO.File(MeryInfo.GetIniPath());
			var modifyDate = new Date(ini.GetDateLastModified());
			if (_info.iniUpdateTime == modifyDate.getTime()) {
				return;
			}
			_info.iniUpdateTime = modifyDate.getTime();

			// ini から必要な設定だけロード
			var ts = ini.LoadText('utf-8').split('\n');
			for (var i=0; i<ts.length; i++) {
				if (ts[i].indexOf('[General]') == 0) {
					ts.splice(0, i+1);
					break;
				}
			}
			var reg = /^(.+?)\=(.*)$/;
			for (var i=0; i<ts.length; i++) {
				if (ts[i].indexOf('[') == 0) {
					break;
				}
				if (reg.test(ts[i])) {
					switch (RegExp.$1.toLowerCase()) {
						case 'wrapmode':
							_info.isWrap = Number(RegExp.$2) != 0;
							break;
						case 'linemargin':
							_info.wrapLen = Number(RegExp.$2);
							break;
						case 'tabcolumns':
							_info.tabSpace = Number(RegExp.$2);
							break;
						case 'insertspaces':
							_info.isTab2Space = Number(RegExp.$2) != 0;
							break;
						case 'autoindent':
							_info.isAutoIndent = Number(RegExp.$2) != 0;
							break;
					}
				}
			}

			// キャッシュの保存
			IO.Serialize(_info, '__MeryInfoCache');
		}

		// Public Static Member Function
		return {
			/**
			 * Meryの設定保存フォルダパス文字列を取得．
			 * @returns {String} 設定保存フォルダパス．
			 */
			GetSettingFolderPath: function() {
				return IO.Path.Add(_shell.SpecialFolders('Appdata'), 'Mery');
			},

			/**
			 * Meryのマクロフォルダパス文字列を取得．
			 * @returns {String} マクロフォルダパス．
			 */
			GetMacroFolderPath: function() {
				return IO.Path.Add(IO.Path.GetParent(Editor.FullName), 'Macros');
			},

			/**
			 * Mery.iniのフォルダパスを取得．<br>
			 * Meryと同様，1.実行ファイル，2.ユーザフォルダの順に探す．
			 * @returns {String} Mery.iniのフォルダパス
			 */
			GetIniPath: function() {
				if (_iniPath == null) {
					if (this.IsPortable()) {
						_iniPath = IO.Path.Add(IO.Path.GetParent(Editor.FullName), 'Mery.ini');
					} else {
						_iniPath = IO.Path.Add(this.GetSettingFolderPath(), 'Mery.ini');
					}
				}
				return _iniPath;
			},

			/**
			 * Mery がポータブルかを取得．<br>
			 * @returns {Boolean} ポータブルの時 true
			 */
			IsPortable: function() {
				if (_isPortable == null) {
					var s = IO.Path.Add(IO.Path.GetParent(Editor.FullName), 'Mery.ini');
					if (IO.Path.IsExist(s)) {
						_isPortable = true;
					} else {
						_isPortable = false;
					}
				}
				return _isPortable;
			},

			/**
			 * 折り返しの有効/無効を取得．
			 * @returns {Boolean} 有効のときtrue．
			 */
			IsWrap: function() {
				if (_info == null) {
					_Init();
				}
				return _info.isWrap;
			},

			/**
			 * 「タブの代わりに空白を挿入」オプションを取得．
			 * @returns {Boolean} オプションが有効か．
			 */
			IsTab2Space: function() {
				if (_info == null) {
					_Init();
				}
				return _info.isTab2Space;
			},

			/**
			 * 「自動インデントを有効にする」オプションを取得．
			 * @returns {Boolean} オプションが有効か．
			 */
			 IsAutoIndent: function() {
				if (_info == null) {
					_Init();
				}
				return _info.isAutoIndent;
			},

			/**
			 * タブ幅を取得．
			 * @returns {Number} タブ幅．
			 */
			 GetTabSpace: function() {
				if (_info == null) {
					_Init();
				}
				return _info.tabSpace;
			},
			
			/**
			 * Mery の開始時刻を取得．
			 * @return {Date} 開始時刻．
			 */
			GetStartDate: function() {
				if (_startDate == null) {
					var oLocator = new ActiveXObject("WBemScripting.SWbemLocator");
					var oService = oLocator.ConnectServer();
					var s = "Select CreationDate From Win32_Process Where ExecutablePath = '" + Editor.FullName.replace(/\\/g, "\\\\") + "' ";
					var result = new Enumerator(oService.ExecQuery(s));
					var out = null;
					if (!result.atEnd()) {
						var t = result.item().CreationDate;
						_startDate = new Date(t.substr(0, 4), t.substr(4, 2) - 1, t.substr(6, 2), t.substr(8, 2), t.substr(10, 2), t.substr(12, 2));
					}
				}
				return _startDate;
			}
		}
	})();
}