var Registory;
if (Registory == null) {
	var Registory = (function(){
		var _locator = new ActiveXObject("WbemScripting.SWbemLocator");
		var _server = _locator.ConnectServer(null, "root\\default");
		var _registry = _server.Get("StdRegProv");

		var _shell = new ActiveXObject('WScript.Shell');

		var _method = _registry.Methods_.Item("EnumKey");
		var _iParams = _method.InParameters.SpawnInstance_();

		return {
			WriteNumber: function(key, number) {
				_shell.RegWrite(key, number, "REG_DWORD");
			},
			WriteString: function(key, text) {
				_shell.RegWrite(key, text, "REG_SZ");
			},
			WriteBool: function(key, bool) {
				_shell.RegWrite(key, bool ? 1 : 0, "REG_BINARY");
			},
			Read: function(key) {
				try {
					return _shell.RegRead(key);
				} catch (e) {}
				return null;
			},
			HasKey: function(key) {
				return Read(key) !== null;
			},
			Delete: function(key) {
				try {
					_shell.RegDelete(key);
					return true;
				} catch (e) {}
				return false;
			},
			GetSubKeys: function(key) {
				if (key.indexOf("HKEY_CLASSES_ROOT\\") == 0 || key.indexOf("HKCR\\") == 0) {
					_iParams.hDefKey = 0x80000000; // HKEY_CLASSES_ROOT
				}
				else if (key.indexOf("HKEY_CURRENT_USER\\") == 0 || key.indexOf("HKCU\\") == 0) {
					_iParams.hDefKey = 0x80000001; // HKEY_CURRENT_USER
				}
				else if (key.indexOf("HKEY_LOCAL_MACHINE\\") == 0 || key.indexOf("HKLM\\") == 0) {
					_iParams.hDefKey = 0x80000002; // HKEY_LOCAL_MACHINE
				}
				else if (key.indexOf("HKEY_USERS\\") == 0) {
					_iParams.hDefKey = 0x80000003; // HKEY_USERS
				}
				else if (key.indexOf("HKEY_PERFORMANCE_DATA\\") == 0) {
					_iParams.hDefKey = 0x80000004; // HKEY_PERFORMANCE_DATA
				}
				else if (key.indexOf("HKEY_CURRENT_CONFIG\\") == 0) {
					_iParams.hDefKey = 0x80000005; // HKEY_CURRENT_CONFIG
				}
				else if (key.indexOf("HKEY_DYN_DATA\\") == 0) {
					_iParams.hDefKey = 0x80000006; // HKEY_DYN_DATA
				} else {
					return [];
				}
				_iParams.sSubKeyName = key.substring(key.indexOf("\\")+1);

				var result = _registry.ExecMethod_(_method.Name, _iParams);
				return result.sNames.toArray();
			}
		};
	})();
}