#include "include/MeryInfo.js"
#title = "SHIORI_Helper"

//==================================================
//【SHIORI_Helper.js】
//2018/03/30
//SHIORI EventIDの解説をアウトプットバーに表示するマクロ
//必須マクロ：includeライブラリ
//└ MeryWiki  https://www.haijin-boys.com/wiki/include%E3%83%A9%E3%82%A4%E3%83%96%E3%83%A9%E3%83%AA#.E8.A3.9C.E8.B6.B3_.28IO.js_.E3.81.AE.E3.82.A8.E3.83.A9.E3.83.BC.E5.AF.BE.E5.BF.9C.29

//改造元マクロ：「説明を出力.js」製作：s氏
//https://www.haijin-boys.com/wiki/%E8%AA%AC%E6%98%8E%E3%82%92%E5%87%BA%E5%8A%9B
//解説引用元
//	- UKADOC Project http://ssp.shillest.net/ukadoc/manual/list_shiori_event.html
//	- 里々Wiki http://soliton.sub.jp/satori/index.php?FrontPage
//	- さとりすとwiki http://wikiwiki.jp/satolist/
//==================================================

//=====定義ファイル指定======
//サブフォルダ以下に配置する場合は「"subFolder名//ファイル名.json"」
var libPath = ["shiori_event.json","shiori_event_ex.json","satori.json"];

//=====表示オプション======
//アウトプットバーを自動表示するか
var barAuto = true;

// ヘルプの表示履歴を残すか（falseで常にひとつ表示する）
var noClear = false;

// 履歴を残すがtrueの時、それぞれの説明の間に空白行を入れるか
var addLine = true;

// 説明の出力形式（trueで説明の前に【ヒットした正規表現】を表示）
var descCfg = true;

//=====オプションここまで======
// 以下本体の処理
var fso = new ActiveXObject("Scripting.FileSystemObject");

//マクロフォルダの相対パス修正
var macroPath= MeryInfo.GetMacroFolderPath();
for(var i = 0; i < libPath.length; i++) {
	if (libPath[i].indexOf(":") <= 0) {
		libPath[i] = macroPath+"\\" + libPath[i] ;
	}
}

// 読み込み
var selectText = document.selection.Text;
var outputText = "";
var outputTitle = "";
for(var i = 0; i < libPath.length; i++) {
	if(fso.FileExists(libPath[i])) {
		var fsIn = fso.OpenTextFile(libPath[i], 1, false, -2);
		var fileJsonText = fsIn.ReadAll();
		var fileJson = JSON.parse(fileJsonText);
		fsIn.Close();

		// 定義ファイル内検索
		for(var j = 0; j < fileJson.length; j++) {
			regexp = new RegExp(fileJson[j].text, fileJson[j].flags)
			if(regexp.exec(selectText)) {
				outputText = fileJson[j].description;
				if(fileJson[j].title) {
					outputTitle = fileJson[j].title;
				} else {
					outputTitle = fileJson[j].text;
				}
			}
		}
	}
}

// アウトプットバー出力
if(selectText !== "" && outputText !== "") {
	if (!OutputBar.Visible && barAuto){ //アウトプットバー自動表示
		OutputBar.Visible = true;
		editor.ExecuteCommandByID(2189); //エディタにフォーカスを戻す
		}
	if(!noClear) { //アウトプットバー内のテキストをクリア
		OutputBar.Clear();
		}
	if(descCfg) { //タイトルとテキスト表示
		OutputBar.Writeln("【" + outputTitle + "】" + outputText);
	} else {
			OutputBar.Writeln(outputText);
			}
	if(noClear && addLine) { // 空白行挿入
		OutputBar.Writeln("");
		}
}
