#include "include/StateBackup.js"

// BookmarkList
//
// 【概要】
//   ブックマークの一覧を取得/設定する
//
// 【使用例】
// var sel = Document.Selection;
// var list = BookmarkList.GetOnSelect(Document, true);
// // 何か操作
// BookmarkList.SetToDocument(Document, list);

var BookmarkList;
if (BookmarkList == null) {
	BookmarkList = (function() {
		// Private Static Member Value

		// Private Static Member Function
		
		// Public Static Member Function
		return {
			/**
			 * 選択範囲のブックマーク一覧を取得．
			 * @param {Document} doc     対象ドキュメント（これが持つ Selection が対象）．
			 * @param {Boolean}  isClear ブックマークの削除フラグ．
			 * @returns {Array} ブックマーク行の一覧．
			 */
			GetOnSelect: function(doc, isClear) {
				var sel = doc.Selection;
				return BookmarkList.GetOnArea(doc, sel.GetTopPointY(mePosLogical), sel.GetBottomPointY(mePosLogical), isClear);
			},

			/**
			 * ブックマークの一覧を取得．
			 * @param {Document} doc     対象ドキュメント．
			 * @param {Number}   top     取得開始位置．
			 * @param {bottom}   bottom  取得終了位置．
			 * @param {Boolean}  isClear ブックマークの削除フラグ．
			 * @returns {Array} ブックマーク行の一覧．
			 */
			GetOnArea: function(doc, top, bottom, isClear) {
				Redraw = false;
				var s = doc.Selection;
				var lines = doc.GetLines(0);
				top = (top == null || top < 1) ? 1 : top;
				bottom = (bottom == null || bottom > lines) ? lines : bottom;
				var state = new StateBackup(doc);
				var b = [];
				// 一行の場合はブックマーク検索でカーソルが移動しないため特殊処理
				if (lines == 1) {
					var isInsert = doc.Text == 0;
					if (isInsert) {
						s.DestructiveInsert(" ");
					}
					s.SetActivePoint(mePosLogical, 2, 1);
					if (s.PreviousBookmark()) {
						b.push(1);
						if (isClear) {
							s.ClearBookmark();
						}
					}
					if (isInsert) {
						doc.Undo();
					}
				} else {
					if (top == 1) {
						s.SetActivePoint(mePosLogical, 1, 2);
						if (s.PreviousBookmark()) {
							b.push(1);
							if (isClear) {
								s.ClearBookmark();
							}
						}
					}
					s.SetActivePoint(mePosLogical, 1, top-1);
					while (s.NextBookmark()) {
						var y = s.GetActivePointY(mePosLogical);
						if (y > bottom) {
							break;
						}
						b.push(y);
						if (isClear) {
							s.ClearBookmark();
						}
					}
				}
				state.Restore();
				return b;
			},

			/**
			 * ブックマークの一覧を取得．
			 * @param {Document} doc     対象ドキュメント．
			 * @param {Boolean}  isClear ブックマークの削除フラグ．
			 * @returns {Array} ブックマーク行の一覧．
			 */
			GetOnDocument: function(doc, isClear) {
				return BookmarkList.GetOnArea(doc, null, null, isClear);
			},

			/**
			 * ブックマークの一覧を設定．
			 * @param {Document} doc     対象ドキュメント．
			 * @param {Boolean}  isClear ブックマークの一覧．
			 */
			SetToDocument: function(doc, list) {
				Redraw = false;
				doc = doc || Editor.ActiveDocument;
				var s = doc.Selection;
				var state = new StateBackup(doc);
				for (var i=0; i<list.length; i++) {
					s.SetActivePoint(mePosLogical, 1, list[i]);
					s.SetBookmark();
				}
				state.Restore();
			}
		};
	})();
}