#include "include/IO.js"

// HTTP
//
// 【概要】
//   ネットワークからファイルを取得する
//
// 【使用例】
// Document.Text = HTTP.GetHtml("http://www.haijin-boys.com/");

var HTTP;
if (HTTP == null) {
	HTTP = (function() {
		// Private Static Member Value
		var _com = new ActiveXObject('MSXML2.XMLHTTP');
		var _status = 0;
		var _Path = IO.Path;

		// Private Static Member Function

		// Public Static Member Function
		return {
			/**
			 * ファイルをダウンロードして保存．
			 * @param {String} url      ファイルの URL．
			 * @param {String} folder   保存先フォルダ．
			 * @param {String} filename 保存ファイル名（省略時は元々のファイル名）．
			 * @returns {String} 保存したファイルのパス．
			 */
			DownloadFile: function(url, folder, filename) {
				var path = _Path.Add(folder, filename || _Path.GetFileName(url));

				_com.open('GET', url, false);
				_com.send();
				_status = _com.status;
				if (_status > 200) {
					//Alert("HTTP エラー: " + _status);
					return _status;
				}
				IO.SaveBinaryToFile(path, _com.responseBody);
				return path;
			},
			/**
			 * HTML のテキストを取得．
			 * @param {String} url   取得対象の URL．
			 * @returns {String} HTML テキスト．
			 */
			GetHtml: function(url) {
				_com.open('GET', url, false);
				_com.send();
				_status = _com.status;

				if (_status > 200) {
					//Alert('HTTP エラー: ' + _status);
					return _status;
				}

				return _com.responseText;
			},
			/**
			 * 最後に取得した HTML の Header の取得．
			 * @param {String} name   ヘッダ名（省略時は全て取得）
			 * @returns {String} ヘッダテキスト．
			 */
			GetHeader: function(name) {
				if (name) {
					return _com.getResponseHeader(name);
				}
				return _com.getAllResponseHeaders();
			}
		};
	})();
}