// StateBackup
//
// 【概要】
//   表示状態（スクロール位置，選択状態）を待避/復元する
//
// 【使用例】
// var state = new StateBackup(Document);
// // 何か操作
// state.Restore();

var StateBackup;
if (StateBackup == null) {
	StateBackup = (function() {
		function StateBackup(doc) {
			// Private Instance Member Value
			var _doc = doc || Editor.ActiveDocument;	// 対象のドキュメント（未指定の場合はアクティブドキュメント）

			// Private Instance Member Function

			// Public Instance Member Value
			this.saved = null;		// 保存済みフラグ．
			this.scrollX = null;	// X 方向スクロール量．
			this.scrollY = null;	// Y 方向スクロール量．
			this.actPos = null;		// カーソル位置．
			this.ancPos = null;		// 選択範囲位置．
			this.isBoxed = null;	// 矩形選択フラグ．	// 現状復元不可能

			// Public Instance Member Function
			/**
			 * 表示状態を待避．
			 */
			this.Backup = function() {
				var sel = _doc.Selection;
				this.saved = _doc.Saved;
				this.scrollX = ScrollX;
				this.scrollY = ScrollY;
				this.actPos = sel.GetActivePos();
				this.ancPos = sel.GetAnchorPos();
				this._isBoxed = (sel.GetBottomPointY(mePosView) - sel.GetTopPointY(mePosView)) != (sel.Text.match(/\n/g) || []).length
			}

			/**
			 * 表示状態を復元．
			 */
			this.Restore = function() {
				var sel = _doc.Selection;
				_doc.Saved = this.saved;
				sel.SetActivePos(this.actPos);
				sel.SetAnchorPos(this.ancPos);
				ScrollX = this.scrollX;
				ScrollY = this.scrollY;
			}

			// Initialize
			this.Backup();
		}

		return StateBackup;
	})();
}