// StopWatch
//
// 【概要】
//   実行時間を計測する
//
// 【使用例】
// var sw = new StopWatch();
// // 何か操作
// Alert(sw);

var StopWatch;
if (StopWatch == null) {
	StopWatch = (function() {
		function StopWatch() {
			// Private Instance Member Value
			var _begin = null;      // 開始時間
			var _end = null;        // 終了時間

			// Private Instance Member Function

			// Public Instance Member Value

			// Public Instance Member Function
			/**
			 * 計測を新たに開始する．
			 */
			this.Restart = function() {
				var d = new Date();
				_begin = d.getTime();
				_end = null;
			}
			/**
			 * 計測を終了する．
			 */
			this.Stop = function() {
				var d = new Date();
				_end = d.getTime();
			}
			/**
			 * 計測中かを取得する．
			 * @returns {Boolean} 計測実行中は True を返す．
			 */
			this.IsRunning = function() {
				return _end == null;
			}
			/**
			 * 経過時間を取得する．
			 * @returns {Number} 経過ミリ秒．
			 */
			this.Elapsed = function() {
				if (_end == null) {
					var d = new Date();
					return d.getTime() - _begin;
				} else {
					return _end - _begin;
				}
			}
			/**
			 * 経過時間を取得する．
			 * @returns {String} 経過ミリ秒．
			 */
			this.toString = function() {
				return String(this.Elapsed());
			}

			// Initialize
			this.Restart();
		}

		return StopWatch;
	})();
}