// WindowsInfo
//
// 【概要】
//   Windows に関する情報を取得する
//
// 【使用例】
// Alert("OS: " + WindowsInfo.GetName() + " " + WindowsInfo.GetArchitecture() + "bit");

var WindowsInfo;
if (WindowsInfo == null) {
	WindowsInfo = (function() {
		// Private Static Member Value
		var _oLocator = new ActiveXObject('WBemScripting.SWbemLocator');
		var _oService = _oLocator.ConnectServer();
		var _shell = new ActiveXObject('WScript.Shell');

		var _ComputerSystem = null;
		var _result = new Enumerator(_oService.ExecQuery('Select * From Win32_ComputerSystem'));
		if (!_result.atEnd()) { _ComputerSystem = _result.item(); }

		var _OperatingSystem = null;
		var _result = new Enumerator(_oService.ExecQuery('Select * From Win32_OperatingSystem'));
		if (!_result.atEnd()) { _OperatingSystem = _result.item(); }

		return {
			// ユーザ名取得
			GetUserName: function() {
				return _ComputerSystem.UserName;
			},
			// OS のビット数を取得
			GetArchitecture: function() {
				return Number(_OperatingSystem.OSArchitecture.match(/^\d*/)[0]);
			},
			// OS のバージョンを取得
			GetVersion: function() {
				return _OperatingSystem.Version;
			},
			// ServicePack のメジャーバージョンを取得
			GetServicePackMajorVersion: function() {
				return _OperatingSystem.ServicePackMajorVersion;
			},
			// ServicePack のマイナーバージョンを取得
			GetServicePackMinorVersion: function() {
				return _OperatingSystem.ServicePackMinorVersion;
			},
			// OS の名称を取得
			GetName: function() {
				return _OperatingSystem.Caption;
			},
			// .Net Framework がインストールされているかを取得
			IsDotNetInstalled: function(ver) {
				var check = function(key) {
					try {
						var isInstalled = _shell.RegRead(key + '\\Install');
						if (isInstalled != null && Number(isInstalled) != 0) {
							return true;
						}
					} catch (e) {}
					return false;
				}
				var checkOver4 = function() {
					var key = 'HKLM\\SOFTWARE\\Microsoft\\NET Framework Setup\\NDP\\v4\\Full';
					if (check(key)) {
						try {
							var release = _shell.RegRead(key + '\\Release');
							if (release != null) {
								if (release > 378681) {
									return '4.5.1';
								} else if (release > 378389) {
									return '4.5';
								}
							}
						} catch (e) {}
					}
					return null;
				}
				switch (ver) {
					case '1.1':
						return check('HKLM\\SOFTWARE\\Microsoft\\NET Framework Setup\\NDP\\v1.1.4322');
					case '2':
					case '2.0':
						return check('HKLM\\SOFTWARE\\Microsoft\\NET Framework Setup\\NDP\\v2.0.50727');
					case '3':
					case '3.0':
						return check('HKLM\\SOFTWARE\\Microsoft\\NET Framework Setup\\NDP\\v3.0');
					case '3.5':
						return check('HKLM\\SOFTWARE\\Microsoft\\NET Framework Setup\\NDP\\v3.5');
					case '4':
					case '4.0':
						return checkOver4() != null || check('HKLM\\SOFTWARE\\Microsoft\\NET Framework Setup\\NDP\\v4.0\\Client');
					case '4.5':
						return checkOver4() != null;
					case '4.5.1':
						return checkOver4() == '4.5.1';
				}
				return false;
			}
		}
	})();
}